using System;

internal class Program
{
    static uint NajvisiKrug(uint[] P, uint M, uint J)
    {
        //broj krugova
        
        //broj slabijih + 2
        //maksimalni krug do kog miljenik moze da dodje je jednak logoritmu baze 2 prvog stepena 2
        //koji je veci od (broja slabijih od miljenika + 2) u slucaju da imamo neograniceno premestanja

        uint slabijih = P[M]-1; //sobzirom da je  1<= Pi <= N i svaki Pi je razlicit to znaci da se svaki broj od 1 do N javlja tacno jednom
                                // /aka ako je P miljenika X ima tacno X-1 slabijih takmicara od njega
        if (slabijih == 0) return 1;

        uint max_moguci_krug = 0;
        for (int i = 1; i < slabijih + 2; i *= 2)
        {
            max_moguci_krug++;
        }
        
        if (J >= slabijih) { return max_moguci_krug; } // ako imamo vise premestanja nego slabijih tamkicara mozemo sve da ih stavimo u grupu sa miljenikom i da mu zagarantujemo maksimalni moguci uspeh

        uint stepen_dvojke = 1;
        uint potrebnih_promena = 0;
        for (uint i = 0; i < max_moguci_krug - 1; i++)
        {
            //racunamo opseg takmicara od kojih ce miljenik morati da bude jaci da bi prosao jedan krug vise, a koje nismo predhodno pregledali
            uint donja_granica = M - (M % (stepen_dvojke * 2));
            uint gornja_granica = M + ((stepen_dvojke * 2) - M % (stepen_dvojke * 2)) - 1;
            if (donja_granica == M - (M % stepen_dvojke)) { donja_granica += stepen_dvojke; }
            else { gornja_granica -= stepen_dvojke; }
            
            stepen_dvojke *= 2;

            for (uint j = donja_granica; j <= gornja_granica; j++)
            {
                if (P[j] > P[M]) { potrebnih_promena++; } // povecavamo broj potrebnih promena za borj jacih od miljenika u datom opsegu
            }
            if (potrebnih_promena > J || potrebnih_promena >= slabijih) { return i + 1; }
        }
        return max_moguci_krug;

    }
    static void Main(string[] args)
    {
        uint N = uint.Parse(Console.ReadLine());
        uint[] P = new uint[N];
        string[] s = Console.ReadLine().Split();
        for (int i = 0; i < N; i++)
        {
            P[i] = uint.Parse(s[i]);
        }
        uint Q = uint.Parse(Console.ReadLine());
        for (int i = 0;i < Q; i++)
        {
            s = Console.ReadLine().Split();
            uint Mi = uint.Parse(s[0]), Ji = uint.Parse(s[1]);
            Console.WriteLine(NajvisiKrug(P, Mi - 1, Ji));
        }
    }
}